<?php
/**
 * Created by PhpStorm.
 * User: win 10
 * Date: 2019/3/14
 * Time: 17:23
 */

namespace app\common\payment;

use think\Request;

require_once(ROOT_PATH.'extend/Alipay/aop/AopClient.php');
require_once(ROOT_PATH.'extend/Alipay/aop/SignData.php');
require_once(ROOT_PATH.'extend/Alipay/aop/request/AlipayFundTransToaccountTransferRequest.php');

class AliTransfer extends DaifuBase
{
    public function pay($cash)
    {

        $Amount = $cash->actual_money;

        $aop = new \AopClient();
        $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';
        $aop->appId = $this->account->params->appId;
        $aop->rsaPrivateKey = $this->account->params->rsaPrivateKey;
        $aop->alipayrsaPublicKey = $this->account->params->alipayrsaPublicKey;
        $aop->apiVersion = '1.0';
        $aop->signType = 'RSA2';
        $aop->postCharset='UTF-8';
        $aop->format='json';
        $request = new \AlipayFundTransToaccountTransferRequest();
        $sysParams = json_encode(array('out_biz_no'=>$cash->orderid,'payee_type'=>'ALIPAY_LOGONID','payee_account'=>$cash->bank_card,'amount'=>$Amount),JSON_UNESCAPED_UNICODE);
        $request->setBizContent($sysParams);
        $result = $aop->execute($request);
        //var_dump($result);die;
        $responseNode = str_replace(".", "_", $request->getApiMethodName()) . "_response";
        $resultCode = $result->$responseNode->code;
        if($result && $resultCode=='10000'){
            return true;
        } else {
            return ['msg' =>$result->$responseNode->sub_msg];
        }
    }
}
